<?php
/*
Template Name: Support Center
*/
get_header();
?>

<div class="container support-page">
    <header class="support-header">
        <h1>📞 1XBET Support Center – 24/7 Assistance</h1>
        <p>Need help with your account, payments, or app installation? Our friendly support team is always here for you.</p>
    </header>

    <section class="support-contact-methods">
        <h2>💬 Get in Touch</h2>
        <ul>
            <li><strong>📧 Email:</strong> <a href="mailto:support@1xbet-download.com">support@1xbet-download.com</a></li>
            <li><strong>🌐 Live Chat:</strong> Available inside the <a href="https://1xbet-download.com/1xbet.apk">1XBET App</a></li>
            <li><strong>📚 FAQ:</strong> <a href="/faq/">Visit FAQ Page</a> for common questions</li>
        </ul>
    </section>

    <section class="support-form">
        <h2>📝 Submit a Request</h2>
        <form action="mailto:support@1xbet-download.com" method="post" enctype="text/plain">
            <label for="name">Your Name (optional):</label>
            <input type="text" id="name" name="name">

            <label for="email">Email Address <span>*</span></label>
            <input type="email" id="email" name="email" required>

            <label for="message">Message <span>*</span></label>
            <textarea id="message" name="message" rows="5" required></textarea>

            <button type="submit">📨 Send Message</button>
        </form>
    </section>

    <section class="support-tips">
        <h2>🔎 Quick Help Tips</h2>
        <ul>
            <li><strong>App not installing?</strong> Make sure you allow apps from unknown sources.</li>
            <li><strong>Payment not processed?</strong> Check your method (Crypto/PayPal) or contact us.</li>
            <li><strong>Forgot login?</strong> Use password recovery via the app login screen.</li>
        </ul>
    </section>
</div>
<style>
    .support-page {
        max-width: 800px;
        margin: auto;
        padding: 2rem;
        line-height: 1.6;
    }
    .support-header h1 {
        font-size: 2rem;
        margin-bottom: 0.5rem;
    }
    .support-contact-methods ul,
    .support-tips ul {
        list-style: none;
        padding-left: 0;
    }
    .support-contact-methods li,
    .support-tips li {
        margin: 0.5rem 0;
    }
    .support-form form {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }
    .support-form input,
    .support-form textarea {
        width: 100%;
        padding: 0.75rem;
        border: 1px solid #ccc;
        border-radius: 6px;
    }
    .support-form button {
        padding: 0.75rem;
        background-color: #0057b8;
        color: white;
        border: none;
        border-radius: 6px;
        font-weight: bold;
        cursor: pointer;
    }
    .support-form button:hover {
        background-color: #004799;
    }
</style>
<?php get_footer(); ?>
