<?php get_header(); ?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
    <header>
        <ol class=breadcrumb>
            <li class=breadcrumb-item><?php if (function_exists('yoast_breadcrumb')) {
                yoast_breadcrumb('<p id="breadcrumbs">', '</p>');
            }
            $pid = $post->ID;
            $title = get_the_title($pid);
            ?></ol>
        <h1><?php the_title(); ?></h1>
        <?php if (has_post_thumbnail()) : ?>
            <div class="post-thumbnail">
                <?php the_post_thumbnail('large'); ?>
            </div>
        <?php endif; ?>
    </header>
    <div class="container">
        <main>
            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <div class="post-content">
                    <?php the_content(); ?>
                </div>
                <div class="post-meta">
                    <p>Posted on: <?php echo get_the_date(); ?></p>
                    <p>Author:
  <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>" rel="author">
    <?php echo esc_html(get_the_author()); ?>
  </a>
</p>
                    <p>Categories: <?php the_category(', '); ?></p>
                </div>
            </article>
            <?php
            // === Related Posts (4 items) ===
            $pid       = get_the_ID();
            $cat_ids   = wp_get_post_terms($pid, 'category', array('fields' => 'ids'));
            $tag_ids   = wp_get_post_terms($pid, 'post_tag', array('fields' => 'ids'));

            $tax_query = array('relation' => 'OR');
            if (!empty($cat_ids)) {
                $tax_query[] = array(
                    'taxonomy' => 'category',
                    'field'    => 'term_id',
                    'terms'    => $cat_ids,
                );
            }
            if (!empty($tag_ids)) {
                $tax_query[] = array(
                    'taxonomy' => 'post_tag',
                    'field'    => 'term_id',
                    'terms'    => $tag_ids,
                );
            }

            $args = array(
                'post_type'           => 'post',
                'posts_per_page'      => 3,
                'post__not_in'        => array($pid),
                'ignore_sticky_posts' => 1,
            );

            // فقط وقتی tax_query داشته باشیم که حداقل یکی از دسته/برچسب وجود داشته باشد
            if (count($tax_query) > 1) {
                $args['tax_query'] = $tax_query;
            }

            $related = new WP_Query($args);

            if ($related->have_posts()) : ?>
                <section class="related-posts">
                    <div class="container">
                        <div class="related-cta">
                            <h2 class="post-title">Related Posts</h2>
                            <p>Also See the below posts if you like to know more about the 1xbet app.</p>
                        </div>

                        <div class="screenshots">
                            <?php while ($related->have_posts()) : $related->the_post(); ?>
                                <div class="screenshot">
                                    <a href="<?php the_permalink(); ?>">
                                        <div class="post-thumbnail">
                                            <?php if (has_post_thumbnail()) {
                                                the_post_thumbnail('medium');
                                            } else {
                                                echo '<img src="' . esc_url(get_template_directory_uri()) . '/images/placeholder.png" alt="No image available">';
                                            } ?>
                                        </div>
                                        <h3><?php the_title(); ?></h3>
                                        <p><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
                                    </a>
                                </div>
                            <?php endwhile; ?>
                        </div>
                    </div>
                </section>
            <?php
            endif;
            wp_reset_postdata();
            ?>
        </main>
    </div>
<?php endwhile; else : ?>
    <p>No posts found.</p>
<?php endif; ?>
<?php get_footer(); ?>
