<?php
function remove_wordpress_version_number()
{
    return '';
}

add_filter('the_generator', 'remove_wordpress_version_number');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'feed_links_extra', 3);
remove_action('wp_head', 'feed_links', 2);
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'wp_oembed_add_discovery_links');
remove_action('template_redirect', 'rest_output_link_header', 11);
add_filter('after_setup_theme', 'remove_redundant_shortlink');
function remove_redundant_shortlink()
{
    remove_action('wp_head', 'wp_shortlink_wp_head', 10);
    remove_action('template_redirect', 'wp_shortlink_header', 11);
}

function clean_header()
{
    wp_deregister_script('comment-reply');
}

add_action('init', 'clean_header');
function xbet_enqueue_styles() {
    wp_enqueue_style('xbet-style', get_stylesheet_uri());
}
add_action('wp_enqueue_scripts', 'xbet_enqueue_styles');
add_theme_support( 'post-thumbnails' );
add_action('wp_print_styles', 'tj_deregister_yarpp_header_styles');
function tj_deregister_yarpp_header_styles()
{
    wp_dequeue_style('yarppWidgetCss');
    // Next line is required if the related.css is loaded in header when disabled in footer.
    wp_deregister_style('yarppRelatedCss');
}

add_action('wp_footer', 'tj_deregister_yarpp_footer_styles');
function tj_deregister_yarpp_footer_styles()
{
    wp_dequeue_style('yarppRelatedCss');
}
add_filter('wp_headers', function ($headers) {
    unset($headers['X-Pingback']);
    return $headers;
});
add_action('wp_print_styles', 'wp_enqueue_styles', 99);
function wp_enqueue_styles()
{
    wp_deregister_style('rpt_front_style');
}
function crunchify_stop_loading_wp_embed_and_jquery()
{
    if (!is_admin()) {
        wp_deregister_script('wp-embed');
        //wp_deregister_script('jquery');  // Bonus: remove jquery too if it's not required
    }
}

add_action('init', 'crunchify_stop_loading_wp_embed_and_jquery');
function remove_wp_block_library_css(){
    wp_dequeue_style( 'wp-block-library' );
    wp_dequeue_style( 'wp-block-library-theme' );
    wp_dequeue_style( 'wc-block-style' );
}
add_action( 'wp_enqueue_scripts', 'remove_wp_block_library_css', PHP_INT_MAX );
add_action('wp_enqueue_scripts', function() {
    global $wp_styles;
    if ( ! is_a( $wp_styles, 'WP_Styles' ) ) {
        return;
    }
    $allowed_style = get_stylesheet_uri();
    foreach ( $wp_styles->queue as $handle ) {
        $style_src = isset( $wp_styles->registered[$handle]->src ) ? $wp_styles->registered[$handle]->src : '';
        if ( $style_src && strpos( $style_src, $allowed_style ) === false ) {
            wp_dequeue_style( $handle );
            wp_deregister_style( $handle );
        }
    }
}, PHP_INT_MAX );
?>