<?php get_header(); ?>

<div class="container">
    <div class="cta">
        <h1 class="post-title"><?php single_cat_title(); ?></h1>
        <p>Browse the latest posts in this category below.</p>
    </div>

    <?php if (have_posts()) : ?>
        <div class="screenshots">
            <?php while (have_posts()) : the_post(); ?>
                <div class="screenshot">
                    <a href="<?php the_permalink(); ?>">
                        <div class="post-thumbnail">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('medium');
                            } else {
                                echo '<img src="' . get_template_directory_uri() . '/images/placeholder.png" alt="No image available">';
                            } ?>
                        </div>
                        <h3><?php the_title(); ?></h3>
                        <p><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
                    </a>
                </div>
            <?php endwhile; ?>
        </div>

        <div class="post-meta">
            <?php the_posts_pagination(array(
                'prev_text' => __('« Previous'),
                'next_text' => __('Next »'),
            )); ?>
        </div>
    <?php else : ?>
        <p>No posts found in this category.</p>
    <?php endif; ?>
</div>

<?php get_footer(); ?>
