<?php get_header(); ?>
<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
    <header>
        <h1><?php the_title(); ?></h1>
    </header>
    <div class="container">
        <main>
            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                <?php if (has_post_thumbnail()) : ?>
                    <div class="post-thumbnail">
                        <?php the_post_thumbnail('large'); ?>
                    </div>
                <?php endif; ?>
                <div class="post-content">
                    <?php the_content(); ?>
                </div>
                <div class="post-meta">
                    <p>Posted on: <?php echo get_the_date(); ?></p>
                    <p>Author: <?php the_author(); ?></p>
                    <p>Categories: <?php the_category(', '); ?></p>
                </div>
            </article>
        </main>
    </div>
<?php endwhile; else : ?>
    <p>No posts found.</p>
<?php endif; ?>
<?php get_footer(); ?>
